import sprites.utils.*;
import sprites.*;

import org.openkinect.freenect.*;
import org.openkinect.processing.*;


//START CONFIGS///
boolean  DEBUG = true;
int INIT_THRESHOLD = 980;
//END CONFIGS//

float scale;

int imageW;
int imageH;
int screenH = 1024;

int bgYOffset = (screenH - 720)/2;

///cam sim//
ArrayList<PVector> camPoints = new ArrayList<PVector>();
PVector activePoint = new PVector(-1, -1);
int camVisW = 720;
int camVisH = 480;
///end cam sim//

///kinect//
KinectTracker tracker;
Kinect kinect; 
///end kinect//

int activePointIdx = 0;
int prevActivePointIdx = -1;

Creature creature;

ScrollingImageLayer mountains;
ScrollingImageLayer cloud1;
ScrollingImageLayer cloud2;
ScrollingImageLayer cloud3;
ScrollingImageLayer foreground;
//ScrollingImageLayer ground;
ScrollingSpriteLayer tree;

ScrollingSpriteLayer hillsBack;
ScrollingSpriteLayer hillsFront;
ScrollingSpriteLayer ground;

StopWatch sw = new StopWatch();

void setup() {
  
  //full size sketch
  fullScreen(SPAN);
 //size(2560, 1024);
  scale = 1;

  //75% size skecth
  //size(1920, 540);
  //scale = 0.75;
  
  //50% size skecth - shows full image
  //size(1920, 360);
  //scale = 0.50;

  imageW = int(3800 * scale);
  imageH = int(720 * scale);
  
  kinect = new Kinect(this);
  tracker = new KinectTracker();
  tracker.setThreshold(INIT_THRESHOLD);
  
  imageMode(CENTER);

  //Background and foreground layers
  mountains = new ScrollingImageLayer("mountains.png", false, imageW/2, imageH/2 + bgYOffset, 0, scale);
  cloud1 = new ScrollingImageLayer( "cloud1.png", false, imageW/2, imageH/2 + bgYOffset, 0.5,scale);
  cloud2 = new ScrollingImageLayer( "cloud2.png", false, imageW/2, imageH/2 + bgYOffset, 0.5, scale);
  cloud3 = new ScrollingImageLayer( "cloud3.png", false, imageW/2, imageH/2 + bgYOffset, 1, scale);
  foreground = new ScrollingImageLayer("foreground.png", true, imageW/2, imageH/2 + bgYOffset, 1, scale);
  hillsBack = new ScrollingSpriteLayer(this, "hills.png", 1, true, imageW/2, imageH/2 + bgYOffset, 1, 40, scale);
  hillsFront = new ScrollingSpriteLayer(this, "hillsFront.png", 1, true, imageW/2, imageH/2 + bgYOffset, 1, 50, scale);
  
  //this may need to be a sprite layer
  ground = new ScrollingSpriteLayer(this, "ground.png", 1, false, imageW/2, imageH/2 + bgYOffset, 0, 55, scale);

  creature = new Creature();
  
  //constructor
  //CreatureSprite(PApplet theApplet, String imgName, int cols, float fs, float xPos, float yPos, float speed, int zIndex, float scale) 
  
  creature.addState(new CreatureSprite(this,"sprite_foreground.png", 8, 0.1f, 600 * scale, (screenH-bgYOffset)-(152 * scale), 0, 45, scale));
  creature.addState(new CreatureSprite(this,"sprite_1.png", 4, 0.2f, 200 * scale, (screenH-bgYOffset)-(150 * scale), 1, 100, scale));
  creature.addState(new CreatureSprite(this,"sprite_2.png", 20, 0.1f, 2500 * scale, (screenH-bgYOffset)-(150 * scale), 1, 100, scale));
  creature.addState(new CreatureSprite(this,"Sprite_3.png", 8, 0.21f, 1625 * scale, (screenH-bgYOffset)-(265 * scale), 1, 100, scale));
  creature.addState(new CreatureSprite(this,"sprite_middleground.png", 5, 0.1f, 160 * scale, (screenH-bgYOffset)-(315 * scale), 1, 100, scale));
  
  tree = new ScrollingSpriteLayer(this, "tree sprite.png", 6, false, 100 * scale, (screenH-bgYOffset)-(420 * scale), 1, 100, scale);

  
  camPoints.add(new PVector(50 * scale, 50 * scale));
  camPoints.add(new PVector(200 * scale, 120 * scale));
  camPoints.add(new PVector(300 * scale, 200 * scale));
  camPoints.add(new PVector(500 * scale, 250 * scale));
  camPoints.add(new PVector(600 * scale, 150 * scale));

  registerMethod("pre", this);
  
  println("creature states: " + creature.getStates().size());
  
}

void draw() {
  //println(displayHeight);
  
  background(0);
  
  fill(#edd8be);
  rect(0, bgYOffset, width, imageH);
  
  mountains.display();
  cloud1.display();
  cloud2.display();
  cloud3.display();
  
  hillsBack.update();
  hillsFront.update();
  tree.update();
  
  
  
  creature.update();
  S4P.drawSprites();
  
  //ground.display();
  foreground.display();
  
  tracker.track();
  
  if(DEBUG){
    imageMode(CORNER);
    tracker.display();
    imageMode(CENTER);
  }
  
  ///kinect camera simulation
  //fill(255, 100);
  //rect(0, 0, camVisW * scale, camVisH * scale);
  //end sim///
  
  PVector lerpAvg = tracker.getLerpedPos();
  float pointDist = Float.MAX_VALUE;
  
  for (int i = 0; i < camPoints.size(); i++) { 
     
    //use mouse for sim
    // float currDist = dist(mouseX, mouseY, camPoints.get(i).x, camPoints.get(i).y);
     
     //use lerpAvg point from cam for installation
     float currDist = dist(lerpAvg.x,  lerpAvg.y, camPoints.get(i).x, camPoints.get(i).y);
     
     if(currDist < pointDist){
       pointDist = currDist; 
       activePointIdx = i;
     } 
     
     if(DEBUG){
       ellipse(camPoints.get(i).x, camPoints.get(i).y, 10, 10);
     }
       
  }
  
  if(activePointIdx != prevActivePointIdx){
    
    //set creature vis that is not the active point
    int randPoint = floor(random(0, creature.getStates().size()));
    while(randPoint == activePointIdx){
      randPoint = floor(random(0, camPoints.size()));
    }
    
    creature.setVisibility(activePointIdx);
    if(DEBUG){
      println("active point idx: " + activePointIdx + " active creature idx: " + randPoint);
    }
  }
  
  ///overlay points of interest
  if(DEBUG){
    fill(255, 0, 0);
    ellipse(camPoints.get(activePointIdx).x, camPoints.get(activePointIdx).y, 10, 10);
    
    //fill(255);
    //if(mouseX < (camVisW * scale) && mouseY < (camVisH * scale)){
     //ellipse(mouseX, mouseY, 20, 20); 
    //}
    
    // Let's draw the "lerped" location
    fill(100, 250, 50, 200);
    noStroke();
    ellipse(lerpAvg.x, lerpAvg.y, 20, 20);
  }
  
  prevActivePointIdx = activePointIdx;
  
  ///end camera simulation
  
}

public void pre() {
  // Calculate time difference since last call
  float elapsedTime = (float) sw.getElapsedTime();
  S4P.updateSprites(elapsedTime);
}


void keyPressed(){
 int t = tracker.getThreshold();
  if (key == CODED) {
    if (keyCode == UP) {
      t+=5;
      tracker.setThreshold(t);
    } else if (keyCode == DOWN) {
      t-=5;
      tracker.setThreshold(t);
    }
  }else{
    if(key == 'd' || key == 'D'){
       DEBUG = !DEBUG; 
    }else{
      String keyChar = str(key);
      creature.setVisibility(int(keyChar) - 1);
    }
    
  }
}
